# -*- coding: utf-8 -*-
"""
Created on Wed Sep 13 16:28:02 2023

@author: yys
"""
import os
import scipy.io as io
import pandas as pd
import numpy as np
from datetime import datetime, timedelta


#读mat 原始 小时数据
TT="201808"
folder_path="J:\\BJ MMCR\\mat\\ls\\"
# folder_path="K:\\sz_I_copy\\MMCR\\BaseDat_C\\sz\\hour_mat\\"
# tt1 = folder_path.split('\\', 3)[3][:-1]
# tt2=tt1


# folder_path="J:\\NJ MMCR\\hour_mat\\ls6001-6653\\"
# tt1=folder_path.split('\\', 3)[2][:-4]
# tt2 = folder_path.split('\\', 3)[3][2:-1]

# # 读mat 原始 日数据
# folder_path="K:\\sz_I_copy\\MMCR\\BaseDatDay_C\\sz\\day_mat\\"
# tt1 = folder_path.split('\\', 5)[5][:-5]
# tt2=tt1

# folder_path="J:\\NJ MMCR\\day_mat\\"
# tt1 = folder_path.split('\\', 3)[2][:-4]
# tt2=tt1

# 创建一个空的DataFrame来存储合并后的数据
merged_ldr1_data = pd.DataFrame()
merged_snr1_data = pd.DataFrame()
merged_snr2_data = pd.DataFrame()
merged_sw1_data = pd.DataFrame()
merged_sw2_data = pd.DataFrame()
merged_vr1_data = pd.DataFrame()
merged_vr2_data = pd.DataFrame()
merged_z1_data = pd.DataFrame()
merged_z2_data = pd.DataFrame()



merged_ldr1_data = merged_ldr1_data.astype('float32')
merged_snr1_data = merged_snr1_data.astype('float32')
merged_snr2_data = merged_snr2_data.astype('float32')
merged_sw1_data = merged_sw1_data.astype('float32')
merged_sw2_data = merged_sw2_data.astype('float32')
merged_vr1_data = merged_vr1_data.astype('float32')
merged_vr2_data = merged_vr2_data.astype('float32')
merged_z1_data = merged_z1_data.astype('float32')
merged_z2_data = merged_z2_data.astype('float32')

# 获取文件夹内所有CSV文件的文件名
mat_files = [file for file in os.listdir(folder_path) if file.endswith('.mat')]

def is_valid_time_format(time_str):
    try:
        datetime.strptime(time_str, "%Y%m%d%H%M.%S")
        return True
    except ValueError:
        return False

# 循环读取每个CSV文件并将其合并到merged_data中
for mat_file in mat_files:
    print(mat_file)
    day=mat_file[15:23]
    mat_path=folder_path+mat_file
    mat = io.loadmat(mat_path)#换文件路径
    height=mat['yRange'].astype('float32')#换结构体名称 对应matlab 工作区
    time=mat['TIME'].astype('str')
    ldr1=mat['ldr1'].astype('float32').T
    snr1=mat['snr1'].astype('float32').T
    snr2=mat['snr2'].astype('float32').T
    sw1=mat['sw1'].astype('float32').T
    sw2=mat['sw2'].astype('float32').T
    vr1=mat['vr1'].astype('float32').T
    vr2=mat['vr2'].astype('float32').T
    z1=mat['z1'].astype('float32').T
    z2=mat['z2'].astype('float32').T
    
# 将时间字符串数组格式化为日期时间对象数组
# 将 numpy 数组转换为列表
# 将 numpy 数组转换为平坦的列表
    time_list = [item for sublist in time.tolist() for item in sublist]
    
    # 初始化索引列表
    valid_indices = []
    invalid_indices = []

    # 检查时间字符串并记录索引
    for idx, time_str in enumerate(time_list):
        if is_valid_time_format(time_str):
            valid_indices.append(idx)
        else:
            invalid_indices.append(idx)
    
    # 获取合法和非法的时间字符串及对应的其它字符串
    valid_time_list = [time_list[i] for i in valid_indices]
    valid_ldr1 = [ldr1[i] for i in valid_indices]
    valid_snr1 = [snr1[i] for i in valid_indices]
    valid_snr2 = [snr2[i] for i in valid_indices]
    valid_sw1 = [sw1[i] for i in valid_indices]
    valid_sw2 = [sw2[i] for i in valid_indices]
    valid_vr1 = [vr1[i] for i in valid_indices]
    valid_vr2 = [vr2[i] for i in valid_indices]
    valid_z1 = [z1[i] for i in valid_indices]
    valid_z2 = [z2[i] for i in valid_indices]
 
    # # # 过滤并格式化合法的时间字符串  单独时间赛选ok
    # valid_time_list = [time_str for time_str in time_list if is_valid_time_format(time_str)]
    formatted_dates = [datetime.strptime(time_str, "%Y%m%d%H%M.%S") for time_str in valid_time_list] 
    
    
    
    # formatted_dates = [datetime.strptime(time_str, "%Y%m%d%H%M.%S") for time_str in time_list]      



#日期时间处理
#     time=(time*60).astype(int)#*60换成当前小时/天的第几分钟
#     hours = (time // 60).astype(int).ravel()
#     minutes = (time % 60).astype(int).ravel()
#     date_obj = datetime.strptime(day, "%Y%m%d")
#     time_str = [f"{h:02d}:{m:02d}" for h, m in zip(hours, minutes)]
# 合并日期和时间
    # combined_datetime = [date_obj + timedelta(hours=int(time.split(':')[0]), minutes=int(time.split(':')[1])) for time in time_str]
# 格式化日期时间
    formatted_datetime = [dt.strftime("%Y-%m-%d %H:%M:%S") for dt in formatted_dates]

    ldr1_data=pd.DataFrame(valid_ldr1)
    ldr1_data.columns = height.ravel()
    ldr1_data.index = pd.to_datetime(formatted_datetime)

    snr1_data=pd.DataFrame(valid_snr1)
    snr1_data.columns = height.ravel()
    snr1_data.index = pd.to_datetime(formatted_datetime)

    snr2_data=pd.DataFrame(valid_snr2)
    snr2_data.columns = height.ravel()
    snr2_data.index = pd.to_datetime(formatted_datetime)

    sw1_data=pd.DataFrame(valid_sw1)
    sw1_data.columns = height.ravel()
    sw1_data.index = pd.to_datetime(formatted_datetime)

    sw2_data=pd.DataFrame(valid_sw2)
    sw2_data.columns = height.ravel()
    sw2_data.index = pd.to_datetime(formatted_datetime)

    vr1_data=pd.DataFrame(valid_vr1)
    vr1_data.columns = height.ravel()
    vr1_data.index = pd.to_datetime(formatted_datetime)

    vr2_data=pd.DataFrame(valid_vr2)
    vr2_data.columns = height.ravel()
    vr2_data.index = pd.to_datetime(formatted_datetime)

    z1_data=pd.DataFrame(valid_z1)
    z1_data.columns = height.ravel()
    z1_data.index = pd.to_datetime(formatted_datetime)

    z2_data=pd.DataFrame(valid_z2)
    z2_data.columns = height.ravel()
    z2_data.index = pd.to_datetime(formatted_datetime)
    #合并
    merged_ldr1_data = pd.concat([merged_ldr1_data, ldr1_data])
    merged_snr1_data = pd.concat([merged_snr1_data, snr1_data])
    merged_snr2_data = pd.concat([merged_snr2_data, snr2_data])
    merged_sw1_data = pd.concat([merged_sw1_data, sw1_data])
    merged_sw2_data = pd.concat([merged_sw2_data, sw2_data])
    merged_vr1_data = pd.concat([merged_vr1_data, vr1_data])
    merged_vr2_data = pd.concat([merged_vr2_data, vr2_data])
    merged_z1_data = pd.concat([merged_z1_data, z1_data])
    merged_z2_data = pd.concat([merged_z2_data, z2_data])
    



# # # 将全是零的格替换为NaN

merged_ldr1_data = merged_ldr1_data.replace(0, np.nan)
merged_snr1_data = merged_snr1_data.replace(0, np.nan)
merged_snr2_data = merged_snr2_data.replace(0, np.nan)
merged_sw1_data = merged_sw1_data.replace(0, np.nan)
merged_sw2_data = merged_sw2_data.replace(0, np.nan)
merged_vr1_data = merged_vr1_data.replace(0, np.nan)
merged_vr2_data = merged_vr2_data.replace(0, np.nan)
merged_z1_data = merged_z1_data.replace(0, np.nan)
merged_z2_data = merged_z2_data.replace(0, np.nan)




# merged_ldr1_data = merged_ldr1_data.apply(lambda col: col if not (col == 0).all() or col.isna().all() else pd.Series([np.nan] * len(col), index=col.index), axis=0)
# # # # 改index名称
merged_ldr1_data = merged_ldr1_data.rename_axis("time(min)/height(m)")
merged_snr1_data = merged_snr1_data.rename_axis("time(min)/height(m)")
merged_snr2_data = merged_snr2_data.rename_axis("time(min)/height(m)")
merged_sw1_data = merged_sw1_data.rename_axis("time(min)/height(m)")
merged_sw2_data = merged_sw2_data.rename_axis("time(min)/height(m)")
merged_vr1_data = merged_vr1_data.rename_axis("time(min)/height(m)")
merged_vr2_data = merged_vr2_data.rename_axis("time(min)/height(m)")
merged_z1_data = merged_z1_data.rename_axis("time(min)/height(m)")
merged_z2_data = merged_z2_data.rename_axis("time(min)/height(m)")

# # # # 将合并后的数据保存为一个新的CSV文件

merged_ldr1_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\ldr_'+TT+'.csv', index=True,encoding='utf-8')
merged_snr1_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\snr1_'+TT+'.csv', index=True,encoding='utf-8')
merged_snr2_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\snr2_'+TT+'.csv', index=True,encoding='utf-8')
merged_sw1_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\sw1_'+TT+'.csv', index=True,encoding='utf-8')
merged_sw2_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\sw2_'+TT+'.csv', index=True,encoding='utf-8')
merged_vr1_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\vr1_'+TT+'.csv', index=True,encoding='utf-8')
merged_vr2_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\vr2_'+TT+'.csv', index=True,encoding='utf-8')
merged_z1_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\z1_'+TT+'.csv', index=True,encoding='utf-8')
merged_z2_data.to_csv('J:\\BJ MMCR\\csv\\'+TT+'\\z2_'+TT+'.csv', index=True,encoding='utf-8')



